
/*:

@target MZ
@plugindesc 言葉を表示する小さめのウィンドウを表示させます。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_WordWindow.js

言葉を表示する小さめのウィンドウを表示させます。


@command appearance
@text ウィンドウ登場
@desc ウィンドウを登場させます。

@command exit
@text ウィンドウ退出
@desc ウィンドウを退出させます。

@command word
@text ウィンドウに表示させる言葉
@desc ウィンドウに表示させる言葉を変更します。「\I[n]」なども使えます。

@arg word
@text 言葉
@desc ウィンドウに表示させる言葉を変更します。「\I[n]」なども使えます。
@type string

@command origin
@text ウィンドウの表示原点
@desc ウィンドウを表示するときの原点を変更します。

@arg origin
@text 原点
@desc ウィンドウを表示するときの原点を変更します。
@type select
@default 中央
@option 中央
@option 左上

@command position
@text ウィンドウを表示させる位置
@desc ウィンドウを表示する位置を変更します。

@arg x
@text x
@desc 表示するxです。
@type number
@default 0

@arg y
@text y
@desc 表示するyです。
@type number
@default 0

@command width
@text ウィンドウの幅を変更
@desc ウィンドウの幅を変更します。（「ウィンドウの幅を固定」をtrueにしないと設定した幅は適用されません。）

@arg width
@text 幅
@desc ウィンドウの幅を変更します。
@type number
@default 0

@command align
@text ウィンドウの文字の位置
@desc ウィンドウの文字の位置を変更します。（「ウィンドウの幅を固定」をtrueにしないと設定した位置は適用されません。）

@arg align
@text 位置
@desc ウィンドウの文字の位置を変更します。
@type select
@default 左
@option 左
@option 中央
@option 右

@command fixedWidth
@text ウィンドウの幅を固定
@desc 設定した幅でウィンドウの幅を固定するか変更します。

@arg fixed
@text 固定
@desc 設定した幅でウィンドウの幅を固定するか変更します。
@on 固定する
@off 固定しない
@type boolean
@default true

@command appearanceType
@text ウィンドウの登場方法
@desc ウィンドウを表示するときの登場方法を変更します。

@arg type
@text 登場方法
@desc ウィンドウの登場方法です。
@type select
@default いきなり現れる
@option いきなり現れる
@option ゆっくり現れる
@option 下から現れる
@option 左から現れる
@option 右から現れる
@option 上から現れる

@command exitType
@text ウィンドウの退出方法
@desc ウィンドウを表示するときの退出方法を変更します。

@arg type
@text 退出方法
@desc ウィンドウの退出方法です。
@type select
@default いきなり消える
@option いきなり消える
@option ゆっくり消える
@option 下に消える
@option 左に消える
@option 右に消える
@option 上に消える

*/

/////////////////グローバルデータ/////////////////
var mk_wordWindow = null;


/////////////////言葉表示ウィンドウデータ/////////////////

function MK_WordWindow() {
    this.word = "";
    this.origin = "中央";//原点
    this.display_x = 0;
    this.display_y = 0;
    this.width = 0;
    this.align = "左";
    this.fixedWidth = false;
    this.appearanceType = "いきなり現れる";//登場方法
    this.exitType = "いきなり消える";//退出方法
    this.now = "none";//現在の状況
}

MK_WordWindow.prototype.Word = function(word) {
    this.word = word;
};

MK_WordWindow.prototype.Origin = function(origin) {////原点
    this.origin = origin;
};

MK_WordWindow.prototype.Display_x = function(x) {
    this.display_x = x;
};

MK_WordWindow.prototype.Display_y = function(y) {
    this.display_y = y;
};

MK_WordWindow.prototype.Width = function(width) {
    this.width = width;
};

MK_WordWindow.prototype.Align = function(align) {
    this.align = align;
};

MK_WordWindow.prototype.FixedWidth = function(fixed) {
    this.fixedWidth = fixed;
};

MK_WordWindow.prototype.AppearanceType = function(type) {//登場方法文字列
    this.appearanceType = type;
};

MK_WordWindow.prototype.ExitType = function(type) {//退出方法文字列
    this.exitType = type;
};

MK_WordWindow.prototype.Now = function(now) {//現在の状況
    this.now = now;
};


/////////////////言葉表示ウィンドウ/////////////////

function MK_WordWindow_Window() {
    this.initialize(...arguments);
}

MK_WordWindow_Window.prototype = Object.create(Window_Base.prototype);
MK_WordWindow_Window.prototype.constructor = MK_WordWindow_Window;

MK_WordWindow_Window.prototype.initialize = function() {
    Window_Base.prototype.initialize.call(this, new Rectangle());
    this.height = this.fittingHeight(1);
    this.mk_now = "none";
    
    if(mk_wordWindow.now == "display"){
        this.mk_now = "display";
        const position = this.MK_DisplayPosition();
        this.x = position.x;
        this.y = position.y;
        this.refresh();
    }else{
        this.hide();
    }
};

MK_WordWindow_Window.prototype.update = function() {
    Window_Base.prototype.update.call(this);
    switch(this.mk_now){
        case "appearance"://登場中
            this.MK_AppearanceUpdate();
            break;
        case "display"://表示中
            this.refresh();
            break;
        case "exit"://退出中
            this.MK_ExitUpdate();
            break;
    }
};

MK_WordWindow_Window.prototype.refresh = function() {
    this.contents.clear();
    this.width = this.MK_Width() + this.padding * 2;
    this.createContents();
    this.drawTextEx(mk_wordWindow.word, this.MK_AlignX(), 0);
};

MK_WordWindow_Window.prototype.MK_AppearanceUpdate = function() {
    const position = this.MK_DisplayPosition();
    const x = position.x;
    const y = position.y;
    const speed1 = 5;
    const speed2 = 17;
    
    if(this.x > x){
        this.x -= speed1;
        if(this.x < x){
            this.x = x;
        }
    }
    
    if(this.x < x){
        this.x += speed1;
        if(this.x > x){
            this.x = x;
        }
    }
    
    if(this.y > y){
        this.y -= speed1;
        if(this.y < y){
            this.y = y;
        }
    }
    
    if(this.y < y){
        this.y += speed1;
        if(this.y > y){
            this.y = y;
        }
    }
    
    if(this.opacity < 255){
        this.opacity += speed2;
        if(this.opacity > 255){
            this.opacity = 255;
        }
    }
    
    if(this.contentsOpacity < 255){
        this.contentsOpacity += speed2;
        if(this.contentsOpacity > 255){
            this.contentsOpacity = 255;
        }
    }
    
    if(this.x == x && this.y == y && this.opacity == 255 && this.contentsOpacity == 255){
        this.mk_now = "display";
    }
    
};

MK_WordWindow_Window.prototype.MK_ExitUpdate = function() {
    const speed1 = 5;
    const speed2 = 17;
    
    switch(mk_wordWindow.exitType){
        case "下に消える":
            this.y = this.y + speed1;
            break;
        case "左に消える":
            this.x = this.x - speed1;
            break;
        case "右に消える":
            this.x = this.x + speed1;
            break;
        case "上に消える":
            this.y = this.y - speed1;
            break;
    }
    
    if(this.opacity > 0){
        this.opacity -= speed2;
        if(this.opacity < 0){
            this.opacity = 0;
        }
    }
    
    if(this.contentsOpacity > 0){
        this.contentsOpacity -= speed2;
        if(this.contentsOpacity < 0){
            this.contentsOpacity = 0;
        }
    }
    
    if(this.opacity == 0 && this.contentsOpacity == 0){
        this.mk_now = "none";
        this.hide();
    }
    
};

MK_WordWindow_Window.prototype.MK_Appearance = function() {
    this.MK_AppearanceType();
    this.mk_now = "appearance";
    this.show();
    this.refresh();
};

MK_WordWindow_Window.prototype.MK_AppearanceType = function() {
    this.opacity = 0;
    this.contentsOpacity = 0;
    const position = this.MK_DisplayPosition();
    this.x = position.x;
    this.y = position.y;
    const startPosition = 80;
    switch(mk_wordWindow.appearanceType){
        case "いきなり現れる":
            this.opacity = 255;
            this.contentsOpacity = 255;
            break;
        case "下から現れる":
            this.y = this.y + startPosition;
            break;
        case "左から現れる":
            this.x = this.x - startPosition;
            break;
        case "右から現れる":
            this.x = this.x + startPosition;
            break;
        case "上から現れる":
            this.y = this.y - startPosition;
            break;
    }
};

MK_WordWindow_Window.prototype.MK_Exit = function() {
    switch(mk_wordWindow.exitType){
        case "いきなり消える":
            this.opacity = 0;
            this.contentsOpacity = 0;
            break;
    }
    this.mk_now = "exit";
};

MK_WordWindow_Window.prototype.MK_DisplayPosition = function() {
    let position = {x : mk_wordWindow.display_x, y : mk_wordWindow.display_y};
    const textWidth = this.MK_Width();
    
    switch(mk_wordWindow.origin){
        case "中央":
            position.x = mk_wordWindow.display_x - textWidth / 2;
            position.y = mk_wordWindow.display_y - this.height / 2;
            break;
    }
    
    return position;
};

MK_WordWindow_Window.prototype.MK_Width = function() {
    if(mk_wordWindow.fixedWidth){
        return mk_wordWindow.width;
    }else{
        return this.textSizeEx(mk_wordWindow.word).width;
    }
};

MK_WordWindow_Window.prototype.MK_AlignX = function() {
    if(mk_wordWindow.fixedWidth){
        const w = this.textSizeEx(mk_wordWindow.word).width;
        switch(mk_wordWindow.align){
            case "左":
                return 0;
                break;
            case "中央":
                return (mk_wordWindow.width - w) / 2;
                break;
            case "右":
                return mk_wordWindow.width - w;
                break;
        }
    }else{
        return 0;
    }
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_WordWindow";
    
    //----------プラグインコマンド----------
    
    //ウィンドウ登場
    PluginManager.registerCommand(pluginName, "appearance", args => {
        mk_wordWindow.Now("appearance");
    });
    
    //ウィンドウ退出
    PluginManager.registerCommand(pluginName, "exit", args => {
        mk_wordWindow.Now("exit");
    });
    
    //ウィンドウに表示させる言葉
    PluginManager.registerCommand(pluginName, "word", args => {
        mk_wordWindow.Word(args.word);
    });
    
    //ウィンドウの表示原点
    PluginManager.registerCommand(pluginName, "origin", args => {
        mk_wordWindow.Origin(args.origin);
    });

    //ウィンドウを表示させる位置
    PluginManager.registerCommand(pluginName, "position", args => {
        mk_wordWindow.Display_x(Number(args.x));
        mk_wordWindow.Display_y(Number(args.y));
    });
    
    //ウィンドウの幅
    PluginManager.registerCommand(pluginName, "width", args => {
        mk_wordWindow.Width(Number(args.width));
    });
    
    //ウィンドウの文字の位置
    PluginManager.registerCommand(pluginName, "align", args => {
        mk_wordWindow.Align(args.align);
    });
    
    //ウィンドウの幅を固定
    PluginManager.registerCommand(pluginName, "fixedWidth", args => {
        mk_wordWindow.FixedWidth((args.fixed == "true") ? true : false);
    });
    
    //ウィンドウの登場方法
    PluginManager.registerCommand(pluginName, "appearanceType", args => {
        mk_wordWindow.AppearanceType(args.type);
    });
    
    //ウィンドウの退出方法
    PluginManager.registerCommand(pluginName, "exitType", args => {
        mk_wordWindow.ExitType(args.type);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //ゲーム開始時作成データ
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.apply(this, arguments);
        mk_wordWindow = new MK_WordWindow();
    };
    
    //セーブ
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        let contents = _DataManager_makeSaveContents.apply(this, arguments);
        contents.mk_wordWindow = mk_wordWindow;
        return contents;
    };
    
    //ロード
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.apply(this, arguments);
        mk_wordWindow = contents.mk_wordWindow;
    };
    
    //----------マップシーン----------
    
    const _Scene_Map_createMapNameWindow = Scene_Map.prototype.createMapNameWindow;
    Scene_Map.prototype.createMapNameWindow = function() {
        _Scene_Map_createMapNameWindow.apply(this, arguments);
        this.mk_wordWindow_window = new MK_WordWindow_Window();
        this.addWindow(this.mk_wordWindow_window);
    };
    
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.apply(this, arguments);
        switch(mk_wordWindow.now){
            case "appearance"://登場
                this.mk_wordWindow_window.MK_Appearance();
                mk_wordWindow.now = "display";
                break;
            case "exit"://退出
                this.mk_wordWindow_window.MK_Exit();
                mk_wordWindow.now = "none";
                break;
        }
    };
    
    
})();
